#ifndef _DM_CRESNET_HARDWARE_HPP_
#define _DM_CRESNET_HARDWARE_HPP_

#include "dm_cresnet.h"

#ifdef DMCARDS_BUILD
#define dim(x) (sizeof(x)/sizeof(x[0]))
#endif

// the base timer class now only has empty virtual functions
class CC_BaseTimer
{
    public:
        UINT8         m_iNumber;

        CC_BaseTimer(void) {
            m_iNumber=0;
        };
        CC_BaseTimer(UINT8 Number) {
            m_iNumber=Number;
        };
        virtual ~CC_BaseTimer() {}  ;

        virtual void  Init(void) {};
        virtual void  DeInit(void) {};

        virtual void ResetTimer(void)  {} ; // stop everything, disable interrupt
        virtual void StartClock(void) {} ;                                    //
        virtual void SetTimer(UINT16 microSeconds) {} ; // start timer
        virtual void EnableTimerInterrupt(void) {} ;
        virtual void DisableTimerInterrupt(void) {} ;
};

// the base timer class now only has empty virtual functions
class CC_BaseUart
{
    public:
        UINT8         m_iNumber;
        BOOL          m_bEnable;

        CC_BaseUart(void) {
            m_iNumber=0  ;
        };
        CC_BaseUart(UINT8 Number) {
            m_iNumber=Number  ;
            m_bEnable = TRUE;
        };
        virtual ~CC_BaseUart() {} ;

        virtual void ResetState(void) {} ; // clear all the variables before polling

        virtual void  Init(void) {} ;
        virtual void  DeInit(void) {} ;

        virtual void EnableRxInterrupt(void) {} ;
        virtual void DisableRxInterrupt(void) {} ;
        virtual void EnableTxInterrupt(void) {} ;
        virtual void DisableTxInterrupt(void) {} ;
        virtual int CheckRxInterrupt(void) { return 0; } ;// returns 1 if int, 0 if not.
        virtual int CheckTxInterrupt(void) { return 0; } ;// returns 1 if int, 0 if not.
                virtual int CheckRxForBreak(void) { return 0; } ; //returns 1 if break is received
                virtual int CheckRxForError(void) { return 0; } ; //returns 1 if overflow

        virtual void WriteBaudRate(UINT32 baud_rate) { } ;
        virtual void DropBus(void)  {  }  ;   // controls Tx-Rx direction
        virtual void GrabBus(void)  {  }  ;   // controls Tx-Rx direction
        virtual void WriteTxBuffer(unsigned char val)  {  }  ;
        virtual unsigned char ReadRxBuffer(void)  { return 0; }     ;
        virtual void ClearOrInt(void)  { return; }     ;

        virtual void ToggleEnable(BOOL bEnable)
        {
            m_bEnable = bEnable;
        }

};

#endif // _DM_CRESNET_HARDWARE_HPP_

